package floweditor.component;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.util.Enumeration;
import javax.swing.JComboBox;

import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.TXDocument;

import floweditor.util.Log;

/** abstract Klasse, von der sich alle weiteren AttributFelder
 *  ableiten */
public class AttrIDREF
    extends javax.swing.JComboBox
    implements CompEventHandler
{
    Component _owner;
    AttDef    _attDef;
    Component _refComp;  // which Component is referenced by 
    boolean   _isValid;
    static String NOVALUE = " --- ";

    protected AttrIDREF(Component owner, AttDef attDef, int columns) {
	// an ID must be set
	// FIXME
	super();
	_owner    = owner;
	_attDef   = attDef;
	_refComp  =  null;
	_isValid  = false;

	String attributeName  = _attDef.getName();
	String attributeValue = _owner.getAttribute (attributeName);
	String elementName    = _owner.getTagName();


	Log.file (1,"AttrIDREF","AttrIDREF (..) ", 
		  elementName + "::" +  
		  attributeName + "::" + 
		  attributeValue); 
	
	/* add Dummy-Field */
	this.addItem (NOVALUE);

	// Liste aller existierenden IDs
	Enumeration enum = _owner.IDs();
	while (enum.hasMoreElements()) {
	    String idValue = (String) enum.nextElement ();
	    _isValid = _isValid || (idValue.equals (attributeValue));
	    this.addItem (idValue);
	}

	if (_isValid) {
	    this.setSelectedItem (attributeValue); 
	} else {
	     this.setSelectedIndex (0); 
        }
	
        this.addActionListener( new ActionListener () {
                public void actionPerformed(ActionEvent e) {
                    AttrIDREF  combobox = AttrIDREF.this;
                    Component component = combobox._owner;
                    String     attrName = (combobox._attDef).getName();
                    String attrValue 
                        = (String) combobox.getSelectedItem();
                    /* attribute got no value (only possible when 
                       attrType == IMPLIED) */
                    if (attrValue == NOVALUE) { 
                        component.setAttribute (attrName, "");
                        attrValue = "";
                    }
                    else 
                        component.setAttribute(attrName, attrValue);
                    component.changeAttributeEvent((CompEventHandler) combobox ,
                                                   attrName, 
                                                   attrValue);
                }
            }   );
	
    }
   
    public  void childRemovedEvent(Component owner, 
				   Component child, 
				   int index)
    {

    }

    public  void childInsertedEvent(Component owner, 
				    Component child, 
				    int index)
    {
	// ignore
    }

    public  void attributeChangedEvent(Component owner, 
				       String attrname, 
				       String value)
    {
	// ignore
    }

    public void checkForConsistency() 
        throws NotWellFormedDocument 
    {
	return;
    }
}
