package floweditor.component;

import java.util.Vector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.MutableTreeNode;

import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.InsertableElement;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.AttDef;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Attr;
import com.ibm.xml.dom.DOMExceptionImpl;

import floweditor.system.ElementBox;
import floweditor.util.Log;

/** Die Klasse Component ist Generalisierung aller
    Klassen, die einem XML-Element zugeordnet werden.
*/
public abstract class Component 
    extends com.ibm.xml.parser.TXElement 
    implements javax.swing.tree.MutableTreeNode,
               CompConstants,
               CompInterface,
               CompEventServer
{
    public Component (String compName) 
    {
	super (compName);
	Log.file(1, compName, compName);
    }

    public void setAttribute(String name, String value) 
    {
        Log.file(1, "Component","setAttribute(String,String)");
	super.setAttribute (name, value);
    }

    public org.w3c.dom.Attr setAttributeNode(org.w3c.dom.Attr attr) {
	Log.file(1, "Component","setAttributeNode(org.w3c.dom.Attr )", attr);
	return super.setAttributeNode(attr);
    } 

    //FIXME
    public abstract void checkForConsistency ()
	throws NotWellFormedDocument;

    /////////////////////////////////////////////////////
    //   Implementation of CompEventServer             //
    /////////////////////////////////////////////////////
    
    Vector _handlerList = new Vector();

    public Vector getEventHandler() { return _handlerList; }

    public void addCompEventHandler(CompEventHandler handler) {
	_handlerList.add(handler);
    }

    public void removeCompEventHandler(CompEventHandler handler) {
	_handlerList.remove(handler);
    }

    
    public void removeChildEvent(CompEventHandler caller, 
				 Component child, int index) 
    {
	System.err.println("received event signal!");
	CompFactory factory = (CompFactory) getFactory();
	factory.setDocumentHasChanged();
	int N = _handlerList.size();
	for(int i = 0; i < N; i++) {
	    CompEventHandler handler 
		= (CompEventHandler) _handlerList.elementAt(i);
	    if (handler != caller) {
		handler.childRemovedEvent(this, child, index); 
	    }
	}
    }

    public void insertChildEvent(CompEventHandler caller, 
				 Component child, int index) 
    {
	System.err.println("received event signal!");
	CompFactory factory = (CompFactory) getFactory();
	factory.setDocumentHasChanged();
	int N = _handlerList.size();
	for(int i = 0; i < N; i++) {
	    CompEventHandler handler 
		= (CompEventHandler) _handlerList.elementAt(i);
	    if (handler != caller) {
		handler.childInsertedEvent(this, child, index); 
	    }
	}
    }

    public void changeAttributeEvent(CompEventHandler caller, 
				     String attrname, String value) 
    {
	String componentName  = this.getTagName();
	String attributeName  = attrname;
	String attributeValue = this.getAttribute(attrname); 
	System.err.println("state: "  
			   +componentName+":"
			   +attributeName+"=="
			   +attributeValue);
	CompFactory factory = (CompFactory) getFactory();
	factory.setDocumentHasChanged();
	int N = _handlerList.size();
	for(int i = 0; i < N; i++) {
	    CompEventHandler handler 
		= (CompEventHandler) _handlerList.elementAt(i);
	    if (handler != caller) {
		handler.attributeChangedEvent(this, attrname, value); 
	    }
	}
    }


    /////////////////////////////////////////////////////
    //   Implementation of javax.swing.tree.TreeNode   //
    /////////////////////////////////////////////////////

    /** Gibt die Kinder als Enumeration zurck
	@return Enumeration
    */
    public Enumeration children () {
	return elements();
    }
    
    /** @return true falls Komponente Kinder hat,
	sonst false.
    */
    public boolean getAllowsChildren () {
	return hasChildNodes ();
    }


    /** @return TreeNode auf gegebenen @param childIndex 
     */
    public TreeNode getChildAt (int childIndex) {
	return  (TreeNode) getChildNodes().item(childIndex);
    }

    /** @return Anzahl der Kinder TreeNodes in der Komponente
     */
    public int getChildCount () {

	NodeList nodelist = getChildNodes();
	return getChildNodes().getLength ();
    }

    /** @return Index der TreeNode in dieser Komponente, 
	oder -1, wenn TreeNode in Komponente ist
    */
    public int getIndex (TreeNode node) {

	NodeList nodelist = getChildNodes();
	int listLength =  nodelist.getLength ();

	int index = 0; 
	while ( (index < listLength) && (nodelist.item(index) != node))
	    {
		index++ ;
	    }
	// index == getLength() oder item(index) == node 

	if (index == listLength) {
	    return -1;
	} else {
	    return index;
	}
    }

    /** @return der Vater TreeNode dieser Komponente
     */
    public TreeNode getParent () {
	return (TreeNode) getParentNode ();
    }

    /** @return true falls falls Komponente keine Kinder
	hat, sonst false.
     */
    public boolean isLeaf () {
	return !hasChildNodes ();
    }

    /** @return den Namen der Komponente als String 
     */
    public String toString () {
	return getTagName ();
    } 


    ////////////////////////////////////////////////////////////
    //   Implementation of javax.swing.tree.MutableTreeNode   //
    ////////////////////////////////////////////////////////////

    /** Fgt in die Komponente ein neues MutableTreeNode child in 
	der Position index ein. 
	@param child
	@param index
     */
    public void insert (MutableTreeNode child, int index) 
    {
	// Fgt Knoten in die Komponente auf der Stelle index ein
	CompFactory factory = (CompFactory) getFactory();
	try {
	    super.insert ((Component) child, index);
	    String idAttrName = ((Component) child).hasIdAttr ();
	    /* child needs ID, so create and register new ID */
	    if (idAttrName != null) {
		((Component) child).lookupID (idAttrName);
	    }
	    factory.setDocumentHasChanged();
	} catch (Exception e) {
	    // angegebene index nicht gltig ( < 0 oder > Anzahl der Kinder)
	    throw new DOMExceptionImpl (DOMExceptionImpl.INDEX_SIZE_ERR, 
					"index doesn't exist");
	}
    }
    
    /** Entfernt Knoten in der Position index aus der Liste der
	Kinderknoten.
     */
    public void remove (int index) 
    {
	MutableTreeNode child = (MutableTreeNode) getChildAt (index);       
	remove (child);
	CompFactory factory = (CompFactory) getFactory();
	factory.setDocumentHasChanged();
    }

    /** Entfernt Kind node aus der Liste der Kinderknoten.
     */
   public void remove (MutableTreeNode node)
    {
	try {
	    Component child = (Component) node;
	    /* if child with ID, delete ID from IDRegister */
	    if (child.hasId ())
		unregistID (child.getAttribute ("ID")); 
	    removeChild (child);
	} catch (Exception e) {
	    throw new DOMExceptionImpl (DOMExceptionImpl.NOT_FOUND_ERR, 
					"child doesn't exist");
	}    
    }
    
    /** Removes the receiver from its parent.
     */
    public void removeFromParent ()
    {
	MutableTreeNode parent = (MutableTreeNode) getParent ();
	parent.remove (this);
    }
    
    /** Sets the parent of the receiver to newParent.
     */
    public void setParent (MutableTreeNode newParent) 
    {
	MutableTreeNode parent = newParent;
    }

    /** Resets the user object of the receiver to object.
     */
    public void setUserObject (Object object) {

    }
    
    /////////////////////////////////////////////////////
    //   Declaration of abstract Methods               //
    /////////////////////////////////////////////////////

    /** Ein Formular-Fenster mit den Attributen der
	Komponente wird zurckgegeben
	@return CompForm 
     */
    public abstract CompForm getCompForm (DefaultTreeModel treemodel);

    /** Eine graphische Darstellung der Komponente
	wird zurckgegeben
	@return CompGraph 	
     */
    public abstract CompGraph getCompGraph ();


    ////////////////////////////////////////////////////////////
    // Implementation of floweditor.component.CompInterface   //
    ////////////////////////////////////////////////////////////

    /** Gibt immer true zurck. Verwendet zur Unterscheidung 
        zwischen Component-Node und Document-Node.
    */
    public boolean isComponent () {
	return true;
    }
    

    /////////////////////////////////////////////////////
    //   Definition of special Methods                 //
    /////////////////////////////////////////////////////

    java.util.Random theRandomGen = new  java.util.Random();

    /**
     * falls @param component noch keine eindeutige ID besitzt, wird eine
     * ID erzeugt und das Element unter dieser ID registriert 
     * @return die neu erzeugte bzw. bereits zugewiesene ID 
     * @see registID(Component, String) 
     * @see unregistID(String)
     * @see checkID(String) 
     * @see IDs()*/
    public String lookupID (String idName)
    {
	Log.file(1, "Component", "lookupID (Element)");
	DTD dtd = getFactory ().getDTD ();
	String idValue = getAttribute (idName);
	if ((idValue == null) || (idValue.length() == 0)) {
	    // element has no ID by now
	    Log.file(1, "Component", "lookupID (Component)", "create new ID");
	    /*
	     * repeat until new id fails for check */
	    do {
		int posRand = theRandomGen.nextInt(10000);
		idValue = "id_" + posRand;
	    } while (dtd.checkID (idValue) != null);
	}
	dtd.registID (this, idValue);
	setAttribute (idName, idValue);
	return idValue;
    }

    /** 
     * 	berprft ob ein component ein Attribut von Typ "ID" besitzt.
     *  @return den Namen des IdAttributes zurck, wenn dieses existiert, 
     *  sonst null
     */
    public String hasIdAttr () {

	String idName = null;
	DTD dtd = getFactory ().getDTD ();

	/* Get all attributes */
	Enumeration attributes = 
	    dtd.getAttributeDeclarations (this.getTagName ());
	/* test if one of these attributes is an ID */
	while (attributes.hasMoreElements ()) {
	    AttDef attrDef = (AttDef) attributes.nextElement ();
	    if (attrDef.getDeclaredType () == AttDef.ID) {
		idName = attrDef.getName ();
	    }  //if
	}    // while
	return idName;
    }
  
    /**
     *  berprft ob component ein Attribut vom Typ "ID" besitzt,
     *  @return true, wenn das der Fall ist, sonst false
     *  @see hasIdAttr () 
     */
    public boolean hasId () {

	boolean hasID = false;
	if (this.hasIdAttr () != null) {
	    hasID = true;
	}
	return hasID;
    }

    /**
     * weist @param component der ID @param id zu.
     * @return true, falls erfolgreich registriert, sonst false
     * @see lookupID(Component, String) 
     * @see unregistID(String)
     * @see checkID(String) 
     * @see IDs()    */
    public boolean registID(Component component, String id) {
	return (getFactory ().getDTD ()).registID (component, id);
    }
    
    /**
     * meldet die ID ab, die ID muss eindeutig im XML-Dokument sein. 
     * @return true, falls erfolgreich abgemeldet, sonst false 
     * @see registID(Component, String) 
     * @see lookupID(Component, String) 
     * @see checkID(String) 
     * @see IDs() */
    public boolean unregistID(String id) {
	return (getFactory().getDTD()).unregistID(id);
    }

    /**
     * berprft die ID auf Existenz, die ID muss eindeutig im
     * XML-Dokument sein.
     * @return das zugewiesene Element
     * @see registID(Component, String) 
     * @see lookupID(Component, String) 
     * @see unregistID(String) 
     * @see IDs() */
    public Component checkID(String id) {
	return (Component) (getFactory().getDTD()).checkID(id);
    }

    /**
     * berprft die ID auf existenz, die ID muss eindeutig im
     * XML-Dokument sein.
     * @return das zugewiesene Element
     * @see registID(Component, String) 
     * @see lookupID(Component, String) 
     * @see unregistID(String) 
     * @see checkID(String) */
    public java.util.Enumeration IDs() {
	return (getFactory().getDTD()).IDs();
    }

    /** gibt zurck, welche Elemente nicht ber das DefaultPopupMenu
     * eingefgt werden drfen  @see floweditor.component.DefaultPopupMenu
     *  */
    public abstract String[] getSuppressedPopupItems();

    /** 
     *  gibt ein Standard-Popup-Menu zurck, falls besondere
     *  Eigenschaften erwnscht sind, muss diese Methode berschrieben
     *  werden @param tree ist der Baum, in dem sich die Komponente
     *  befindet @see getSuppressedPopupItems() */
    public CompPopupMenu getPopupMenu (JTree tree, ElementBox elembox, int row){
	Log.file(1, "Component", "getPopupMenu (JTree)"); 
	return new DefaultPopupMenu (this, tree, elembox, row);
    }
    
    /** gibt eine Enumeration mit String zurck, die die Deklaration
        @see com.ibm.xml.parser.AttDef jedes zulssigen Attributes
        enthlt. */
    public Enumeration getAttributeNames() {
	Log.file(1, "Component", "getAttributeNames()");

	String compName       = this.getTagName(); 
	DTD      dtd          = (this.getFactory()).getDTD();
	Enumeration attrEnum  = dtd.getAttributeDeclarations(compName);
	return attrEnum;
    }

    /** gibt ein JComponent-Object zurck, die die Schnittstelle
     *  eines Attributes von einer Komponente darstellt.    */
    public JComponent createAttributeField (AttDef attDef, String attName) 
	throws floweditor.component.UnknownAttributeException
    {
	Log.file(1, "Component", "createAttributeField(AttDef, String)");

	switch(attDef.getDeclaredType()) { 
	case AttDef.CDATA:
	    Log.file(1, "Component", "createAttributeField(String)","CDATA");
	    return new AttrCDATA (this, attDef, 15); 
	case AttDef.IDREF:
	    Log.file(1, "Component", "createAttributeField(String)","IDREF");
	    return new AttrIDREF(this, attDef, 15);
	case AttDef.NOTATION:
	case AttDef.NAME_TOKEN_GROUP:
	    Log.file(1, "Component", "createAttributeField(String)",
		     "NAME_TOKEN_GROUP");
	    return new AttrNameTokenGroup(this, attDef, 15);
	case AttDef.ID:
	    Log.file(1, "Component", "createAttributeField(String)","ID");
	    return new AttrID(this, attDef, 15);
	default:
	    System.err.println(this.getTagName() + ":" + attName + " is ???");
	    Log.file(1, "Component", "createAttributeField(String)","CDATA");
	    return new AttrCDATA(this, attDef, 15); 
	}
    }
    
    /** gibt ein JComponent-Object zurck, die die Schnittstelle 
     *	zu einer Komponente darstellt, die ein PCDATA-Object enthlt.
     *  (@see DESCRIPTION)
     */
    public JComponent createTextNodeField () 
	throws floweditor.component.NotWellFormedDocument
    {
	Log.file(1, "Component", "createTextNodeField()");
	return new TextNodeField (this, 3, 25);
    }    

    /** Gibt true zurck wenn Komponente ein Kind der Sorte PCDATA
     *  hat..
     *  @see CompAttributeEditor.
     */
    public boolean hasTextNode () {
// 	String[] suppressedItems = {DTD.CM_EOC,
// 				    DTD.CM_ERROR};
// 	Hashtable appendables  = getAppendableElements (suppressedItems);
// 	if (appendables.size () == 1 &&
// 	    appendables.containsKey (DTD.CM_PCDATA))
// 	    return true;
// 	else 
	return false;
	
    }
    
    /**
     * Ermittelt die Menge der als Kind an @param parent index einsetzbaren
     * Elemente anhand der DTD, die Validitt bleibt nach Einsetzen
     * eines jeweiligen Elementes erhalten.
     * @return ist Hashtable, der Key ist ein String, das ausgelesenen
     * Object ist vom Typ com.ibm.xml.parser.InsertableElement z.B:
     * insertable=(InsertableElement)hashtable.get("MODEL"); oder auch
     * discarded=(InsertableElement)hashtable.remove(DTD.CM_PCDATA);
     * In der Rueckgabeliste kann auch CM_PCDATA vorkommen.
     *
     * Diese Methode bezieht sich immer nur auf die einfgbaren
     * Kinder, niemals auf einfgare Nachbarn dieser Komponente
     * selbst. Um zu ermitteln, welches Element als Nachbar eingefgt
     * werden knnte, muss der Vater-Knoten dieser Komponente selbst
     * gefragt werden.*/
    public Hashtable getInsertableElements (int index) 
    {
	String element = this.getNodeName ();
	TXDocument factory = this.getFactory();
	DTD dtd = factory.getDTD();

	Hashtable prepared;
	Hashtable insertables;
       
	prepared    = dtd.prepareTable (element);
	insertables = 
	    dtd.getInsertableElementsForValidContent (this, index, prepared);
	if (insertables==null) {
	    return new Hashtable();
	} else {
	    return insertables;
	}
    }

    /**
     *  Diese Methode ist identisch zu der vorherigen, nur kann diese
     *  Methode weiterhin dazu genutzt werden, einige Element-Namen
     *  mit @suppress herauszufiltern*/
    public Hashtable getInsertableElements (int index, String[] suppress) {
	Hashtable table = getInsertableElements(index);
	for (int i = 0; i < suppress.length; i++) {
	    table.remove (suppress[i]);
	}
	return table;
    } 

    /** @deprecated */
    public Hashtable getInsertableElementsInTree (int index) {
	Hashtable table = getInsertableElements(index);
	table.remove (DTD.CM_PCDATA);
	table.remove (DTD.CM_EOC);
	table.remove (DTD.CM_ERROR);
	return table;
    } 

    /** @deprecated */
    public Hashtable getInsertableElementsInForm  (int index) {
	Hashtable table = getInsertableElements(index);
	table.remove (DTD.CM_PCDATA);
	table.remove (DTD.CM_EOC);
	table.remove (DTD.CM_ERROR);
	return table;
    }

    /**
     * Ermittelt die Menge der als Kind anfgbaren Elemente anhand der
     * DTD, die Validitt bleibt nach Anhngen eines jeweiligen
     * Elementes erhalten.
     * @return ist HashTable, der Key ist ein String, das ausgelesenen
     * Object ist vom Typ com.ibm.xml.parser.InsertableElement z.B:
     * insertable=(InsertableElement)hashtable.get("MODEL"); oder auch
     * discarded=(InsertableElement)hashtable.remove(DTD.CM_PCDATA);
     * In der Rueckgabeliste kann auch CM_PCDATA vorkommen.
     *
     * Diese Methode bezieht sich immer nur auf die einfgbaren
     * Kinder, niemals auf einfgare Nachbarn dieser Komponente
     * selbst. Um zu ermitteln, welches Element als Nachbar eingefgt
     * werden knnte, muss der Vater-Knoten dieser Komponente selbst
     * gefragt werden. */

    public Hashtable getAppendableElements () {
	String element = this.getNodeName ();
	TXDocument factory = this.getFactory();

	DTD dtd = factory.getDTD();

	Hashtable prepared;
	Hashtable insertables;

	prepared = dtd.prepareTable (element);
	insertables = dtd.getAppendableElements ((Element)this, prepared);
	
	if (insertables==null) {
	    return new Hashtable();
	} else {
	    return insertables;
	}
    } 

    /**
     *  mit @param suppress knnen die zu unterdrckenden Elemente
     *  angegeben werden. Diese erscheinen nicht in der
     *  Hashtable. @see getAppendableElements() */
    public Hashtable getAppendableElements (String[] suppress) {
	Hashtable table = getAppendableElements();
	for(int i = 0; i < suppress.length; i++) {
	    table.remove(suppress[i]);
	}
	return table;
    }

    /** @deprecated */
    public Hashtable getAppendableElementsInTree () {
	Hashtable table = getAppendableElements();
	table.remove (DTD.CM_PCDATA);
	table.remove (DTD.CM_EOC);
	table.remove (DTD.CM_ERROR);
	return table;
    }
    
    /** @deprecated */
    public Hashtable getAppendableElementsInForm () {
	Hashtable table = getAppendableElements();
	table.remove (DTD.CM_PCDATA);
	table.remove (DTD.CM_EOC);
	table.remove (DTD.CM_ERROR);
	return table;
    }
    
	
    /*
      Wird von einem Kind aufgerufen und ermittelt, welche Elemente
      vor dem Kind @argument child eingefuegt werden koennten
      @return Liste der vor dem aufrufenden Kind einfuegbaren Elemente
      Schluessel der Hastable sind die Namen der Element als
      java.lang.String, verwaltetes Objekt der Hashtable ist
      com.ibm.xml.parser.InsertableElement */
    
    public Hashtable getInsertableElementsBeforeChild (Component child) {
	if (FACTORY_DEBUG) {
	    if (child==null) {
		Log.file(1, "Component",
			 "getInsertableElementsBeforeChild (Component)", 
			 "ERROR: child == null");
		System.exit (1);
	    }
	}

	/*
	  Find index of child
	 */
	NodeList nodelist = this.getChildNodes();
	int listLength =  nodelist.getLength ();

	int index = 0; 
	while ( (index < listLength) && (nodelist.item(index) != child))
	    {
		index++ ;
	    }
	// index == getLength() oder item(index) == node 

	if (FACTORY_DEBUG) {
	    if (index==listLength) {
		Log.file(1, "Component",
			 "getInsertableElementsBeforeChild: ",
			 "ERROR: child not within list");
		System.exit (1);
	    }
	}	
	/*
	 *  bei korrektem Aufruf muss das Element ein Kind dieses
	 *  Knotens sein index ist die Position (0..N-1) des Kindes.
	 *  Ein Element, das vor dem Kind eingefuegt wuerde, haette
	 *  selbst den aktuellen Index des Kindes, das derzeitige Kind
	 *  wuerde nach dem Einfuegen index+1 bekommen */
	return getInsertableElements (index); 
    }

    /** 
     * @see getInsertableElementsBeforeChild (Component), @param
     * suppress gibt an, welche Element unterdrckt werden sollen. */
    public Hashtable getInsertableElementsBeforeChild (Component child, 
	        				       String[] suppress) {
	Hashtable table = getInsertableElementsBeforeChild(child);
	for(int i = 0; i < suppress.length; i++) {
	    table.remove(suppress[i]);
	} 
	return table;
    } 


    /** @deprecated */
    public Hashtable getInsertableElementsInTreeBeforeChild (Component child) {
	Hashtable table = getInsertableElementsBeforeChild(child);
	table.remove (DTD.CM_PCDATA);
	table.remove (DTD.CM_EOC);
	table.remove (DTD.CM_ERROR);	
	return table;
    } 

    /** @deprecated */
    public Hashtable getInsertableElementsInFormBeforeChild (Component child) {
	Hashtable table = getInsertableElementsBeforeChild(child);
	table.remove (DTD.CM_PCDATA);
	table.remove (DTD.CM_EOC);
	table.remove (DTD.CM_ERROR);
	return table;
    }

}






