package floweditor.component;
 
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent; 

import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import floweditor.system.ElementBox;
import floweditor.util.Log;   

/** Class RemoveListener implements function "remove"
    offered by PopupMenu
*/
public class RemoveListener 
    implements ActionListener 
{
    private Component _comp;
    private String    _label;
    private DefaultTreeModel _treemodel;
    private ElementBox _elembox;
    private JTree      _tree;
    private int        _row;
    
    public RemoveListener (Component comp, 
			   String label,
			   JTree tree,
			   DefaultTreeModel treemodel,
			   ElementBox elembox,
			   int row) 
    {
	_comp      = comp;
	_label     = label;
	_treemodel = treemodel;
        _elembox    = elembox;
        _tree      = tree;
        _row       = row;    }
    
    public void actionPerformed (ActionEvent e) 
    {
	Component parent     = (Component) _comp.getParentNode();
	CompForm  parentForm = parent.getCompForm (_treemodel);
        _elembox.changeContent (parentForm);
	
	TreePath treePath = _tree.getPathForRow (_row);
	TreePath parentPath = treePath.getParentPath ();
	_tree.setSelectionPath (parentPath);
	_treemodel.removeNodeFromParent (_comp);
    }
}
