package floweditor.pool.MODEL.ACCESSRESTRICTION;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.Box;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.DefaultTreeModel;

import com.ibm.xml.parser.DTD;

import floweditor.util.Log;
import floweditor.component.Component;
import floweditor.component.CompForm;
import floweditor.component.CompAttributeEditor;
import floweditor.component.CompGraphEditor;
import floweditor.component.DefaultGraphEditor;
import floweditor.component.CompGraph;
import floweditor.component.DefaultGraph;

import floweditor.component.NotWellFormedDocument;
import floweditor.component.CompEventHandler;

public class ACCESSRESTRICTION
    extends Component 
{

    /** 
     * Methode fr die Instanzierung einer Comp-Komponente.  */
    public ACCESSRESTRICTION() 
    {
	super ("ACCESSRESTRICTION");
    }

    /**
     * erzeugt eine GUI in Formularform, mit der Attribute und
     * Substrukturen manipuliert werden knnen */
    public CompForm getCompForm (DefaultTreeModel treemodel)
    {
	//nothing to show really ...
	if (_form == null) {
	    _form = new Formular ();
	}
	return _form;
    }

    /**
     * gibt die graphische Instanz dieser Komponenten-Instanz
     * zurck. Mehrmalige Aufrufe geben immer das selbe Objekt zurck */
    public CompGraph getCompGraph () 
    {
	if (_graph == null) {	    
            String idName = hasIdAttr();
	    Color  color  = Color.white;
            if ( idName != null) {
                String label = getAttribute (idName);
                _graph = new DefaultGraph (this, label, color);
            } else {
                String label = getTagName ();
                _graph = new DefaultGraph (this, label, color);               
            }
	}
	return _graph;
    }
    
    /** definiert, welche Elemente diese Komponente nicht ber das
     * PopupMenu eingefgt bekommen mchte 
     * @see floweditor.component.DefaultPopupmenu
     *  */
    public  String[] getSuppressedPopupItems() 
    {
	String[] suppressedItems = {DTD.CM_PCDATA, 
				    DTD.CM_EOC, 
				    DTD.CM_ERROR};
	return suppressedItems;
    }


    /** definiert EventHandler fr checkConsistency */
    public void checkForConsistency () 
        throws NotWellFormedDocument
    {
        DTD dtd  = getFactory().getDTD ();
        /* now do syntax-check */
        if ( hasChildNodes ()) {
            Enumeration children = this.children ();
            while (children.hasMoreElements () ){
                Component child    = (Component) children.nextElement ();
                if (dtd.validate (child) == null) {
		    child.checkForConsistency ();
		} else {
		     //FIXME which Node is wrong? 
		    throw new NotWellFormedDocument ("Syntax error occured: " +
						     "Element "+child.getTagName()+
						     " wrong defined." +
						     " Attribute or child node" +
						     " missing.\n" +
						     "Unable to save",
						     child);
		}
	    } /* end while */
        }  /* end if (1) */
        /* after correct syntax, check the semantics */
	Vector _handlerList = getEventHandler();
	int N = _handlerList.size();
	for(int i = 0; i < N; i++) {
	    CompEventHandler handler 
		= (CompEventHandler) _handlerList.elementAt(i);
	    handler.checkForConsistency ();
	}
    }

    /**
     * Innere Klasse die das Form-Fenster der
     * Comp-Komponente definiert.  */
    private class Formular extends CompForm 
    {
        public Formular () 
        {
            super ();

            CompAttributeEditor attrEditor 
                = new CompAttributeEditor (ACCESSRESTRICTION.this);
            JScrollPane panelOne = new JScrollPane (attrEditor);
            
	    // kein graphEditor fr diese Komponente vorhanden 
	    // CompGraphEditor graphEditor 
	    //      = new DefaultGraphEditor (ACCESSRESTRICTION.this,
	    //                                8, 8, 140, 100);
            // JScrollPane panelTwo = new JScrollPane (graphEditor);
	    
            addToTabPane (panelOne, "ACCESSRESTRICTION ATTRIBUTES");
	}

	/** Darstellung in GraphEditor aktualisieren wenn eine 
	    Kind-Komponente entfernt wurde.
	*/
	public void update () 
	{
	    //nothing to update
	}
		
	/**
	 * 
	 */
	public void checkData () 
	{
	    ;
	}

    }
    
    Formular    _form = null;
    CompGraph   _graph = null;
}


