package floweditor.pool.MODEL.PARAMETER;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.util.Vector;

import javax.swing.JComboBox;

import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.AttDef;

import floweditor.component.Component;
import floweditor.component.CompEventHandler;
import floweditor.component.NotWellFormedDocument;

import floweditor.util.Log;


/** Klasse, die Textfield darstellt, auf der den Wert des Attributes
 *  TYPE eingetragen bzw. dargestellt wird. 
 */
public class AttrTYPE
    extends javax.swing.JComboBox
    implements CompEventHandler
{
    Component _owner;
    AttDef    _attDef;
    boolean   _isValid;
    Vector    _dataTypes = new Vector ();
    /* Standard (java) dataTypes */
    String OTHER   = "";
    static private String STRING  = "string";
    static private String INTEGER = "integer";
    static private String FLOAT   = "float";
    
    /** */
    protected AttrTYPE (Component owner, AttDef attDef, int columns) {
	// FIXME
	super();
	_owner = owner;
	_attDef = attDef;
	_isValid = false;
	this.setEditable (true);

	String  attributeName   = _attDef.getName();
	String  attributeValue  = 
	    (_owner.getAttribute(attributeName)).toLowerCase ();

        Log.file(1,"MODEL.PARAMETER:", 
		 "AttrTYPE (Component, AttDef, String)",
                 attributeName + "::" +
                 attributeValue);

	/* test: if attribute value defined and != standard values,
	   so is OTHER == value */
	if (attributeValue != null &&
	    !attributeValue.equals(STRING) &&
	    !attributeValue.equals(INTEGER) &&
	    !attributeValue.equals(FLOAT) 
	    ) {
	    OTHER = attributeValue;
	}
	/* add standard data types in Vector _dataTypes */ 
	_dataTypes.addElement (STRING);
	_dataTypes.addElement (INTEGER);
	_dataTypes.addElement (FLOAT);
	
	/* add standard data types as items in combobox */
	for (int i = 0; i < _dataTypes.size(); i++) {
	    String item = (String) _dataTypes.elementAt (i);
	    _isValid = _isValid || (item.equals(attributeValue));
	    this.addItem (item);
	}

	/* and also self defined type*/
	this.addItem (OTHER);
	
	/* mark selected item */
	if (_isValid) {
	    this.setSelectedItem (attributeValue); 
	} else {
	    this.setSelectedItem (OTHER); 
	}

	this.addActionListener( new ActionListener () {
		public void actionPerformed(ActionEvent e) {
		    AttrTYPE combobox   = AttrTYPE.this;
		    Component component = combobox._owner;
		    String     attrName = (combobox._attDef).getName();
		    
		    /* get entered/choosen value */
                    String    firstValue = (String) combobox.getSelectedItem ();
		    /* transform String to lower case, in case
		       entered value == a standard value, just written 
		       something different */
                    String    attrValue  = firstValue.toLowerCase ();
                    int selected = combobox.getSelectedIndex ();
		    /* own data type defined */
		    if (selected == -1 &&
                        !attrValue.equals (STRING) &&
                        !attrValue.equals (INTEGER) &&
                        !attrValue.equals (FLOAT) )
		    {
		       combobox.removeItem (OTHER);
		       OTHER = attrValue;
		       combobox.addItem (OTHER);
		       combobox.setSelectedItem (OTHER);
		    }  else { /* standard datatype choosen/entered */
 			combobox.setSelectedItem (attrValue);		    
 		    }

		    /* if attrvalue a empty string, remove attribute */
                    if ((attrValue.trim ()).length () == 0)
                        component.setAttribute (attrName, null);
                    else 
			component.setAttribute (attrName, attrValue); 
		    component.changeAttributeEvent((CompEventHandler) combobox, 
						   attrName, 
						   attrValue);
		}
	    }   );
	
    }
   
    public  void childRemovedEvent(Component owner, 
				   Component child, 
				   int index)
    {
	// ignore
    }

    public  void childInsertedEvent(Component owner, 
				    Component child, 
				    int index)
    {
	// ignore
    }

    public  void attributeChangedEvent(Component owner, 
				       String attrname, 
				       String value)
    {
	Log.file(1,"AttrTYPE", "attributeChangedEvent(..)");
	if ((_owner == owner) && (attrname == _attDef.getName())){
	    this.setSelectedItem (value);
	}
    }

    public void checkForConsistency() 
        throws NotWellFormedDocument 
    {
	Log.file (1, "PARAMETER.AttrTYPE", "checkForConsistency()", _owner);
	String attrValue = (String) this.getSelectedItem ();
	if (attrValue.equals (OTHER)) {
	    if (attrValue == null || ((attrValue.trim()).length () == 0)) 
		throw new NotWellFormedDocument ("PARAMETER:AttrTYPE \n" +
						 "Error: no value given " +
						 "for PARAMETER type! \n"+
						 "Enter a new type or choose " +
						 "a standard type",
						 _owner);
	}
	/*end if*/
    }
    

}
