package floweditor.pool.MODEL.PARTICIPANT;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.util.Enumeration;
import javax.swing.JComboBox;

import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.AttDef;

import floweditor.component.Component;
import floweditor.component.CompEventHandler;
import floweditor.component.NotWellFormedDocument;

import floweditor.util.Log;


/** Klasse, die Textfield darstellt, auf der den Wert des Attributes
 *  TYPE eingetragen bzw. dargestellt wird. 
 */
public class AttrTYPE
    extends javax.swing.JComboBox
    implements CompEventHandler
{
    Component _owner;
    AttDef    _attDef;
    boolean   _isValid;

    /** */
    protected AttrTYPE (Component owner, AttDef attDef, int columns) {
	// FIXME
	super();
	_owner = owner;
	_attDef = attDef;
	_isValid = false;
	
	String  attributeName   = _attDef.getName();
	String  attributeValue  = _owner.getAttribute(attributeName);
	String  attDefaultValue = _attDef.getDefaultStringValue();

	Log.file (1, "PARTICIPANT.AttrTYPE",
		  "AttrTYPE (Comp, ..)",
		  attributeName + "::" +
		  attributeValue);

	/* get list of all tokens that can be used as values for this 
	   enumerated attribute type. These values become items in 
	   comboBox */
	Enumeration enum = attDef.elements();
	while (enum.hasMoreElements()) {
	    String item = (String) enum.nextElement();
	    _isValid = _isValid || (item.equals(attributeValue));
	    this.addItem(item);
	}

	if (_isValid) {
	    this.setSelectedItem(attributeValue); 
	} else if (attDefaultValue != null) {
	    this.setSelectedItem(attDefaultValue); 
	    _owner.setAttribute (attributeName, attDefaultValue);
	} else {
	    this.setSelectedIndex(0); 
	    _owner.setAttribute (attributeName, (String) this.getItemAt (0));
	}
	//_owner.setAttribute (attributeName, (String) getSelectedItem ());
	
	this.addActionListener( new ActionListener () {
		public void actionPerformed(ActionEvent e) {
		    AttrTYPE combobox = AttrTYPE.this;
		    Component component = combobox._owner;
		    String     attrName = (combobox._attDef).getName();
		    String attrValue 
			= (String) combobox.getSelectedItem();
		    component.setAttribute(attrName, attrValue);
		    component.changeAttributeEvent((CompEventHandler) combobox , 
						   attrName, 
						   attrValue);
		}
	    }   );

    }
   
    public  void childRemovedEvent(Component owner, 
				   Component child, 
				   int index)
    {
	// ignore
    }

    public  void childInsertedEvent(Component owner, 
				    Component child, 
				    int index)
    {
	// ignore
    }

    public  void attributeChangedEvent(Component owner, 
				       String attrname, 
				       String value)
    {
	Log.file(1,"AttrTYPE", "attributeChangedEvent(..)");
	if ((_owner == owner) && (attrname == _attDef.getName())){
	    this.setSelectedItem (value);
	}
    }

    public void checkForConsistency() 
        throws NotWellFormedDocument 
    {
	Log.file (1, "PARTICIPANT.AttrTYPE", "checkForConsistency()", _owner);
	String attrValue = (String) this.getSelectedItem();	
	if (attrValue == null || ((attrValue.trim()).length () == 0)) 
		throw new NotWellFormedDocument ("PARTICIPANT.AttrTYPE \n" +
						 "Error: no value given for " +
                                                 "PARTICIPANT type! \n" +
						 "choose a value for type" ,
						 _owner);	
    }
    

}
