package floweditor.system;

import java.awt.Color;
import java.awt.Dimension;
import java.io.Reader;
import java.io.Writer;
import java.io.IOException;

import javax.swing.Box;
import javax.swing.BoxLayout;

import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.JTree;
import javax.swing.SwingUtilities;

import javax.swing.tree.TreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

import java.awt.event.MouseEvent;
import java.awt.event.MouseAdapter;

import org.w3c.dom.Element;
                              
import com.ibm.xml.parser.Parser; 
import com.ibm.xml.parser.Parent;

import floweditor.component.Component;
import floweditor.component.CompInterface;
import floweditor.component.CompFactory;
import floweditor.component.CompForm;
import floweditor.component.CompPopupMenu;
import floweditor.component.NotWellFormedDocument;

import floweditor.util.Log;

public class DocumentBox extends Box {
    
    public DocumentBox (BoxLayout layout, ElementBox elembox) {
	super (layout.X_AXIS);	
	_elembox = elembox;
    }

    public boolean hasChanged () {
        return _compFactory.documentHasChanged ();
    }
    
    public void writeStream (Writer writer) 
	throws IOException, NotWellFormedDocument
    {
	Log.file (1,"DocumentBox","writeStream");
	
	_compFactory.checkForConsistency ();	
	_compFactory.setEncoding ("ISO-8859-1");
	_compFactory.printWithFormat (writer);
	
    }

    /** Setzt  den Focus auf die angegebene Komponente
     */
    public void setFocus (Component comp) 
    {
	TreeNode[] compArray = _compTreeModel.getPathToRoot (comp);
	TreePath  compPath   = new TreePath (compArray);
	_compTree.setSelectionPath (compPath);
	_elembox.changeContent (comp.getCompForm (_compTreeModel));	
    }


    public void readStream (Reader reader, String streamName) 
	throws Exception 
    {
	Log.file (1, "DocumentBox", "readStream (Reader , String)");
        /*
        if (this.hasChanged ()) {
            throw new LostOfInformation 
	    ("Das Modell sollte zuvor abgespeichert werden");
        }
        */
        _compFactory        = new CompFactory ();
        Parser parser       = new Parser (streamName);
        parser.setKeepComment    (false);
        parser.setElementFactory (_compFactory);

        try {
            parser.readStream (reader);	    
	    this.changeContentTree ();
        } catch (Exception e) {
            throw e;
        }	
    }

    /*
      void writeStream (Writer writer) 
      throws XXX
      {
      /
      sync wirft XXX
      /
      this.sync ();
      
      _compFactory.writeStream (writer);
      /
      Schreiben erfolgreich implies _compFactory.hasChanged() == false
      /
      }
    */

    public void changeContentTree ()
    //throws NoChangePossible 
    {
	Log.file (1, "DocumentBox", "changeContentTree ()");
	invalidate ();
	if (_docPanel!=null) {
	    remove (_docPanel);
	}
	
	_compTree = new JTree (_compFactory);
	_compTree.setCellRenderer (createRenderer ());
	_compTreeModel = (DefaultTreeModel) _compTree.getModel ();
	_compFactory.setTreeModel(_compTreeModel);
	
        _docPanel = new JScrollPane (_compTree);
	_docPanel.setPreferredSize (new Dimension (200, 580));
	_docPanel.setMinimumSize(new Dimension (200,580));
        ScrollPaneLayout spl = new ScrollPaneLayout ();
        _docPanel.setLayout (spl);
        spl.syncWithScrollPane (_docPanel);

	Component firstComp = (Component) _compFactory. getDocumentElement();
        CompForm firstForm = firstComp.getCompForm (_compTreeModel);
        _elembox.changeContent (firstForm);
        this.add (_docPanel);

        validate (); 
        repaint ();

        _compTree.addMouseListener(new MouseAdapter () {
                public void mousePressed (MouseEvent e) {
		    
                    JTree tree = (JTree) e.getSource ();
                    int row = tree.getRowForLocation (e.getX (), e.getY ());
		    
                    if (row != -1) {

			tree.setSelectionRow (row);
                        TreePath path 
			    = tree.getPathForLocation (e.getX(), e.getY ());
                        CompInterface node 
			    = (CompInterface) path.getLastPathComponent ();
                        if (node.isComponent() ) {
 
                            Component component        = (Component) node;
			    DefaultTreeModel treemodel 
				= (DefaultTreeModel) tree.getModel ();
                            CompForm  form             
				= component.getCompForm (treemodel);
			    tree.expandPath(path);
                            if (SwingUtilities.isLeftMouseButton (e) ) {
                                _elembox.changeContent (form);
				tree.expandRow (row);
                            } else if (SwingUtilities.isRightMouseButton (e)) {
				_elembox.changeContent (form);
                                CompPopupMenu popUp 
				    = component.getPopupMenu (tree,_elembox, row); 
                                popUp.show (_docPanel, e.getX (), e.getY () );
			    }
                            
                        } else {
                           System.err.println ("I'm document!"); 
                        }
                    } else {
                        //do nothing
                    }
                }
            });
        
    }

    /*
    public void sync () 
	throws Exception 
    {
	_form.sync ();
    }
    */

    // Aussehen einer Cell wenn diese ausgewahlt wird, done by TreeCellRenderer
    protected  DefaultTreeCellRenderer createRenderer () {
        
        _renderer = new DefaultTreeCellRenderer ();
        _renderer.setBackgroundSelectionColor (Color.yellow);
        _renderer.setBackgroundNonSelectionColor (Color.white);
        _renderer.setTextSelectionColor (Color.red);
        
        return _renderer;
    }
    
    /* */

    ElementBox _elembox;
    CompFactory _compFactory;

    JScrollPane      _docPanel = null;
    JTree            _compTree;
    DefaultTreeModel _compTreeModel;
    DefaultTreeCellRenderer _renderer;

}












