package floweditor.util;

import java.awt.Point;
import java.util.Hashtable;

import floweditor.component.Component;

public class Topology {
    Hashtable _vertPos;   // ID -> Point
    Hashtable _edgeType;  // ID -> EdgeType
    Hashtable _actTable;  // ID -> Component

    
    protected Topology (Hashtable vertPos, Hashtable edgeType, Hashtable activityTable) {
	_vertPos  = (Hashtable) vertPos.clone();
	_edgeType = (Hashtable) edgeType.clone();
	_actTable = (Hashtable) activityTable.clone ();
    } 
    
    /** 
     * @return Position of vertex assigned to @param id, when id not
     * part of based net null will be returned */
    public Point getPosition (String id) { 
	return (Point) _vertPos.get (id);
    }

    public EdgeType getEdgeType(String from, String to) {
	return (EdgeType) _edgeType.get (new Edge (from, to));
    }

    public Component getActivity (String id) {
	return (Component) _actTable.get (id); ;

    }
}
